<?php
/**
 * The portfolio archive showcases your portfolio items with a filterable option.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */


get_header(); // Loads the header.php template

//start page loop
if (have_posts()) : ?>

<div id="page-heading">
	<?php if( get_post_meta($post->ID, 'att_custom_pp_title', TRUE) == '') { ?>
		<h1><?php if ( of_get_option('portfolio_title') ) echo of_get_option('portfolio_title'); else _e('Portfolio','att'); ?></h1>
	<?php } else { ?>
		<h1><?php echo get_post_meta($post->ID, 'att_custom_pp_title', TRUE); ?></h1>
	<?php } ?>
</div><!-- /page-heading -->

<div id="portfolio-template">

	<?php 
	//get portfolio categories
	$att_port_cats = get_terms('portfolio_category', array( 'hide_empty' => '1' ) );
	
	//show filter if categories exist
	if($att_port_cats) { ?>
	<!-- Portfolio Filter -->
	<ul id="portfolio-cats" class="filter clearfix">
		<li><a href="#" class="active" data-filter="*"><span><?php _e('Show All', 'att'); ?></span></a></li>
		<?php
		foreach ($att_port_cats as $att_port_cat ) : ?>
		<li><a href="#" data-filter=".<?php echo $att_port_cat->slug; ?>"><span><?php echo $att_port_cat->name; ?></span></a></li>
		<?php endforeach; ?>
	</ul><!-- /portfolio-cats -->
	<?php } ?>
    
    <div id="portfolio-wrap">
    	<div id="portfolio-filter-content" class="portfolio-content clearfix">
			<?php
            while (have_posts()) : the_post();
				 get_template_part('content','portfolio');
			endwhile; ?>
		</div><!-- /portfolio-filter-content -->
        <?php att_pagination(); // Paginate your pages ?>
		<?php wp_reset_query(); // Rest the query to avoid any conflicts ?>
    </div><!-- /portfolio-wrap -->
</div><!-- /portfolio-template -->
<?php
endif;
get_footer(); // Loads the footer.php file ?>