<?php
/**
 * Author.php loads the author pages with a listing of their posts
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */

get_header(); // Loads the header.php template
if( have_posts() ) : // Start main loop ?>

<header id="page-heading">
	<?php
    if(isset($_GET['author_name'])) {
		 $curauth = get_userdatabylogin($author_name);
	} else {
    	$curauth = get_userdata(intval($author));
	} ?>
    <h1><?php _e('Posts by','att'); ?>: <?php echo $curauth->display_name; ?></h1>
</header><!-- /page-heading -->

<div id="post" class="post clearfix">  
	<?php
	while (have_posts()) : the_post();
		get_template_part( 'content', get_post_format() ); 
	endwhile;	
    att_pagejump(); ?>
</div><!--/post -->

<?php
endif; // End main loop
get_sidebar(); // Loads the sidebar.php file
get_footer(); // Loads the footer.php file