<?php
/**
 * This file is used for your portfolio entries.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */
 
/*--------------------------------------------------*/
/* Show Other Posts @ Random
/*--------------------------------------------------*/
if( of_get_option('portfolio_more') !== '1' ) {
	//get post type ==> portfolio
	global $post;
	$more_portfolio_posts = get_posts(
		array(
			'exclude' => get_post_meta( get_the_ID() ),
			'orderby' => 'rand',
			'post_type' =>'portfolio',
			'numberposts' => '4',
			'suppress_filters' => false
		)
	);
	
	//show portfolio section if posts exist
	if( $more_portfolio_posts ) { ?>
		<div class="clear"></div>
		<div id="single-portfolio-related" class="clearfix">
			<h3 class="heading"><span><?php _e('Similar Work','att'); ?></span></h3>
			<div class="grid-container">
			   <?php 
				foreach ($more_portfolio_posts as $post ) : setup_postdata( $post ); ?>
                	<article class="portfolio-entry grid-4 <?php if($terms) foreach ($terms as $term) echo $term->slug .' '; ?>">
						<?php
                        if(has_post_thumbnail()) {  ?>
                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="overlayparent"><img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ),  att_img( 'port_entry_width' ), att_img( 'port_entry_height' ), att_img( 'port_entry_crop' ) ); ?>" alt="<?php the_title(); ?>" class="portfolio-entry-img" /></a>
                        <?php } ?>
                    </article><!-- /portfolio-entry -->
				<?php endforeach; ?>
			</div><!--/grid-container -->
		</div><!-- /single-portfolio-related -->
<?php wp_reset_postdata(); } }