<?php
/**
 * This file is used for your portfolio entries.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */


/******************************************************
 * Single Posts
 * @since 1.0
*****************************************************/
if ( is_singular('portfolio') ) {


	//get post image attachments
	$att_port_single_attachments = get_posts(
		array(
			'orderby' => 'menu_order',
			'post_type' => 'attachment',
			'post_parent' => get_the_ID(),
			'post_mime_type' => 'image',
			'post_status' => null,
			'posts_per_page' => -1
		)
	); ?>
	
	<div id="page-heading">
		<h1><?php the_title(); ?></h1>
		<div id="post-pagination" class="clearfix">
			<div class="post-prev"><?php next_post_link('%link', __('Previous','wpex'), false); ?></div> 
			<div class="post-next"><?php previous_post_link('%link', __('Next','wpex'), false); ?></div>
		</div><!-- /post-pagination -->
	</div><!-- /page-heading -->
	
	<article id="single-portfolio-post" class="clearfix"> 
	
		<div class="clearfix">
	   
			<div id="single-portfolio-media" class="clearfix fitvids">
				<?php
				/*--------------------------------------*/
				/* Single Featured Image Post Style
				/*--------------------------------------*/
				if( get_post_meta( get_the_ID(), 'att_portfolio_post_style', true ) == 'Featured Image' || get_post_meta( get_the_ID(), 'att_portfolio_post_style', true ) == '' ) {	
			
					//show featured image if defined
					if( has_post_thumbnail() ) {
					?>
						<div class="post-thumbnail">
							<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id(), 'full' ); ?>" title="<?php the_title(); ?>" class="prettyphoto-link"><img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ),  att_img( 'port_post_width' ), att_img( 'port_post_height' ), att_img( 'port_post_crop' ) ); ?>" alt="<?php echo the_title(); ?>" /></a>
						</div><!-- /post-thumbnail -->
						<?php att_post_feat_img_caption(); ?>
					<?php } 
					}
				/*--------------------------------------*/
				/* Slider Post Style
				/*--------------------------------------*/
				elseif ( get_post_meta( get_the_ID(), 'att_portfolio_post_style', true ) == 'Image Slider' ) { ?>
					<div class="flexslider-container">
						<div id="slider-<?php get_the_ID(); ?>" class="flexslider">
							<ul class="slides">
								<?php
								//loop through attachments
								foreach ( $att_port_single_attachments as $att_port_single_attachment ) :
								
								// Get and crop featured image
								$att_port_single_img = aq_resize( wp_get_attachment_url( $att_port_single_attachment->ID,'full' ),  att_img( 'port_post_width' ), att_img( 'port_post_height' ), att_img( 'port_post_crop' ) );
								
								//include image in slider/gallery
								if( get_post_meta($att_port_single_attachment->ID, 'be_rotator_include', true) !== '1' ) {
								?>
								<li class="slide">
									<a href="<?php echo wp_get_attachment_url( $att_port_single_attachment->ID,'full' ); ?>" title="<?php the_title(); ?>" rel="prettyPhoto[portfolio_gallery]"><img src="<?php echo $att_port_single_img; ?>" alt="<?php echo the_title(); ?>" /></a>
									<?php if ( $att_port_single_attachment->post_content !== '' ) { ?>
										<p class="single-portfolio-image-description"><?php echo $att_port_single_attachment->post_content; ?></p><!-- /single-portfolio-description -->
									<?php } ?>
								</li>
								<?php } endforeach; ?>
							</ul><!-- /slides -->
						</div><!-- /flexslider -->
					</div><!-- /flexslider-container -->
				<?php }
				/*--------------------------------------*/
				/* Stacked Images Post Style
				/*--------------------------------------*/
				elseif ( get_post_meta( get_the_ID(), 'att_portfolio_post_style', true ) == 'Stacked Images' ) {
					
					// Loop through attachments
					foreach ( $att_port_single_attachments as $att_port_single_attachment ) :
					
					// Get resize & crop the featured image
					$att_port_single_img = aq_resize( wp_get_attachment_url( $att_port_single_attachment->ID,'full' ),  att_img( 'port_post_width' ), att_img( 'port_post_height' ), att_img( 'port_post_crop' ) );
		
					// Check if this image should be included
					if( get_post_meta($att_port_single_attachment->ID, 'be_rotator_include', true) != '1') {
					?>
					<div class="single-portfolio-stacked-image">
						<a href="<?php echo wp_get_attachment_url( $att_port_single_attachment->ID, 'full' ); ?>" title="<?php the_title(); ?>" rel="prettyPhoto[portfolio_gallery]"><img src="<?php echo $att_port_single_img; ?>" alt="<?php echo the_title(); ?>" /></a>
						<?php if ( $att_port_single_attachment->post_content !== '' ) { ?>
						<p class="single-portfolio-image-description"><?php echo $att_port_single_attachment->post_content; ?></p><!-- /single-portfolio-description -->
						<?php } ?>
					</div><!-- /single-portfolio-stacked-image -->
					<?php } endforeach;
				} 
				/*--------------------------------------*/
				/* Video Post Style
				/*--------------------------------------*/
				elseif ( get_post_meta( get_the_ID(), 'att_portfolio_post_style', true ) == 'Video' ) {
					echo wp_oembed_get( get_post_meta( get_the_ID(), 'att_portfolio_post_video', true ) );
				} ?>  
			</div><!-- /single-portfolio-media -->
			
			<div id="single-portfolio-info" class="entry clearfix">
				<?php the_content(); ?>
			</div><!-- /single-portfolio-info -->
		
		</div><!-- /portfolio-content -->
		
		<?php
		// Get comments template if enabled
		if( of_get_option('toggle_portfolio_comments','1') == '1' ) {
			comments_template();
		}
		
		// Show Related Posts
		if( of_get_option('toggle_portfolio_more','1') == '1' ) {
			get_template_part('content','portfolio-related'); 
		} ?>
	
	</article><!-- /post -->
    
    
    
<?php
/******************************************************
 * Entries
 * @since 1.0
*****************************************************/
} else {
	$terms = get_the_terms( get_the_ID(), 'portfolio_category' ); ?>

    <article class="portfolio-entry grid-4 <?php if($terms) foreach ($terms as $term) echo $term->slug .' '; ?>">
        <?php
        if(has_post_thumbnail()) {  ?>
            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="overlayparent"><img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ),  att_img( 'port_entry_width' ), att_img( 'port_entry_height' ), att_img( 'port_entry_crop' ) ); ?>" alt="<?php the_title(); ?>" class="portfolio-entry-img" /></a>
        <?php } ?>
    </article><!-- /portfolio-entry -->


<?php }