<?php
/**
 * This file is used to show your homepage slides
 * @package Agency WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */

if ( class_exists( 'Authentic_Slides_Post_Type' ) && of_get_option('slides_alt') == '' ) {
	global $post;
	$slides = get_posts( array(
		'post_type' => 'slides',
		'numberposts' => '-1',
		'order' => 'DESC'
	));
	if($slides) { ?>
    <div id="home-slider-wrap" class="clearfix">
        <div id="home-slider" class="flexslider">
            <ul class="slides">
                <?php foreach( $slides as $post ) :	setup_postdata($post); ?>
                <?php if( has_post_thumbnail() || get_post_meta( get_the_ID(), 'att_slides_video', true) ){ ?>
                    <li>
                    	<div class="slide-inner grid-1 fitvids">
                        	<?php if( get_post_meta( get_the_ID(), 'att_slides_video', true) !== '' ) {
								echo wp_oembed_get( get_post_meta( get_the_ID(), 'att_slides_video', true ) );
							} else {
								if( get_post_meta( get_the_ID(), 'att_slides_url', true) !== '' ) { ?>
                                <a href="<?php echo get_post_meta( get_the_ID(), 'att_slides_url', true); ?>" title="<?php the_title(); ?>" target="_<?php echo get_post_meta( get_the_ID(), 'att_slides_url_target', true); ?>">
                                	<img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id(), 'full' ); ?>" alt="<?php the_title(); ?>" />
                                </a>
								<?php } else { ?>
                            	<img src="<?php echo wp_get_attachment_url( get_post_thumbnail_id(), 'full' ); ?>" alt="<?php the_title(); ?>" />
							<?php }
                             }
							 if($post->post_content !=='') { ?>
                                <div class="flex-caption"><?php the_content(); ?></div>
                            <?php } ?>
                        </div><!--/ slide-inner -->
                    </li>
                <?php } ?>
                <?php endforeach; wp_reset_postdata(); ?>
            </ul><!-- /slides -->
        </div><!-- /home-slider -->
    </div><!-- /home-slider-wrap -->
	<?php } 
}

if( of_get_option('slides_alt') !== '' ){
	echo '<div id="homepage-slider-alt">'. of_get_option('slides_alt') .'</div>';	
}