<?php
/**
 * This file is used for your blog and archive entries.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */
 
 
 
/******************************************************
 * Single Posts
 * @since 1.0
*****************************************************/
if ( is_singular() && is_main_query() ) { ?>


    <div id="post-heading">
        <header>
            <h1><?php the_title(); ?></h1>
            <ul class="meta clearfix">
                 <li><span><?php _e('Posted on', 'att'); ?></span> <?php the_time('jS F Y'); ?>,</li> 
                 <li><span><?php _e('written by', 'att'); ?></span> <?php the_author_posts_link(); ?></li>   
                 <?php if(comments_open()) { ?><li class="comment-scroll"><span><?php _e('with', 'att'); ?></span> <?php comments_popup_link(__('0 Comments', 'att'), __('1 Comment', 'att'), __('% Comments', 'att'), 'comments-link' ); ?></li><?php } ?>
            </ul>
            <div id="post-pagination" class="clearfix">
                <div class="post-prev"><?php next_post_link('%link', __('Previous','wpex'), false); ?></div> 
                <div class="post-next"><?php previous_post_link('%link', __('Next','wpex'), false); ?></div>
            </div><!-- /post-pagination -->
        </header>
    </div><!-- /post-heading -->
    
    <div id="post" class="single-post clearfix">
    
        <?php
        // Get resize and show featured image : refer to functions/img_defaults.php for default values
        if( of_get_option('blog_single_thumbnail') == '1' && has_post_thumbnail() ) {
            ?>
                <div id="post-thumbnail">
                    <img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ),  att_img( 'blog_width' ), att_img( 'blog_height' ), att_img( 'blog_crop' ) ); ?>" alt="<?php echo the_title(); ?>" />
                </div><!-- /post-thumbnail -->
        <?php } ?>
        
        <article class="entry clearfix">
            <?php the_content(); // This is your main post content output ?>
        </article><!-- /entry -->
        
        <?php wp_link_pages(); // Paginate pages when <!- next --> is used ?>
        
        <?php comments_template(); ?>
            
    </div><!-- /post -->


<?php
/******************************************************
 * Entries
 * @since 1.0
*****************************************************/
} else { ?>


    <article <?php post_class('loop-entry clearfix'); ?>>  
    
        <header class="post-heading">
            <h2><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
        </header>
    
         <ul class="meta clearfix">
             <li><span><?php _e('Posted on', 'att'); ?></span> <?php the_time('jS F Y'); ?>,</li> 
             <li><span><?php _e('written by', 'att'); ?></span> <?php the_author_posts_link(); ?></li>   
             <?php if(comments_open()) { ?><li><span><?php _e('with', 'att'); ?></span> <?php comments_popup_link(__('0 Comments', 'att'), __('1 Comment', 'att'), __('% Comments', 'att'), 'comments-link' ); ?></li><?php } ?>
        </ul>
    
        <?php
        /* Post Thumbnail*/
        if( has_post_thumbnail() ) {  ?>
            <div class="loop-entry-thumbnail">
                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><img src="<?php echo aq_resize( wp_get_attachment_url( get_post_thumbnail_id(), 'full' ),  att_img( 'blog_width' ), att_img( 'blog_height' ), att_img( 'blog_crop' ) ); ?>" alt="<?php echo the_title(); ?>" /></a>
            </div><!-- /loop-entry-thumbnail -->
        <?php } ?>
        
        <div class="entry-content">
            <div class="entry-text">
                <?php the_excerpt(); ?>
            </div><!-- /entry-text -->
            <a class="theme-button" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php _e('Continue Reading','att'); ?></a>
        </div><!-- /entry-content -->  
    </article><!-- /entry -->


<?php } ?>