<?php
/**
 * Functions.php contains all the core functions for your theme to work properly.
 * Please do not edit this file!!
 *
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */
 
 
 

/**
 * Define Constants
 * since 1.0
 */
define( 'ATT_JS_DIR', get_template_directory_uri().'/js' );
define( 'ATT_CSS_DIR', get_template_directory_uri().'/css' );





/*
 * Helper function to return the theme option value. If no value has been saved, it returns $default.
 * Needed because options are saved as serialized strings.
 *
 * This code allows the theme to work without errors if the Options Framework plugin has been disabled.
 * @since 1.0
 */
if ( !function_exists( 'of_get_option' ) ) {
	function of_get_option($name, $default = false) {
		$optionsframework_settings = get_option('optionsframework');
		// Gets the unique option id
		$option_name = $optionsframework_settings['id'];
		if ( get_option($option_name) ) {
			$options = get_option($option_name);
		}
		if ( isset($options[$name]) ) {
			return $options[$name];
		} else {
			return $default;
		}
	}
}





/**
 * Get functions
 * @since 1.0
 */

// Load CSS and JS
require_once( get_template_directory() .'/functions/scripts.php' );

//Aqua resizer
if ( !function_exists( 'aq_resize' ) ) {
	require_once( get_template_directory() .'/functions/aqua-resizer.php' );
}

// Setup some useful functions
require_once ( get_template_directory() .'/functions/recommend-plugins.php' );
require_once( get_template_directory() .'/functions/support-external-plugins.php' );
require_once( get_template_directory() .'/functions/image-default-sizes.php' );
require_once( get_template_directory() .'/functions/comments-callback.php' );
require_once( get_template_directory() .'/functions/pagination.php' );
require_once( get_template_directory() .'/functions/posts-per-page.php' );

require_once( get_template_directory() .'/functions/widgets/widget-areas.php' );
require_once( get_template_directory() .'/functions/widgets/widget-post-thumbs.php' );
require_once( get_template_directory() .'/functions/widgets/widget-portfolio-thumbs.php' );

//load these functions only in the admin dashboard
if( defined('WP_ADMIN') && WP_ADMIN ) {
	if ( class_exists( 'Authentic_Slides_Post_Type' ) ) {
		require_once( get_template_directory() .'/functions/meta/meta-slides.php' ); // Services meta
	}
	if ( class_exists( 'Authentic_Portfolio_Post_Type' ) ) {
		require_once( get_template_directory() .'/functions/meta/meta-portfolio.php' ); // Portfolio meta
	}
	require_once( get_template_directory() .'/functions/meta/meta-page.php' );
	require_once( get_template_directory() .'/functions/meta/meta-post.php' );
}




/**
 * Localization support
 * @since 1.0
 */
load_theme_textdomain( 'att', get_template_directory() .'/lang' );





/**
 * Set the content width based on the theme's design and stylesheet.
 * @since 1.0
 */
$content_width = 940;



/**
 * Sets up theme defaults and registers support for various WordPress features.
 * @since 1.0
 */
if ( ! function_exists( 'att_setup' ) ) :

	function att_setup() {
		
		
		//theme support
		add_theme_support('automatic-feed-links');
		add_theme_support('custom-background');
		add_theme_support('post-thumbnails');
		
		//register navigation menus
		if ( ! function_exists ( 'att_register_nav_menus' ) ) {
			function att_register_nav_menus ( ) {
				$att_menus = array(
					'main_menu' => __( 'Main', 'att' )
				);
				$att_menus = apply_filters ( 'att_nav_menus', $att_menus );
				register_nav_menus ( $att_menus );
			}
		}
		att_register_nav_menus();
	
	}
	add_action( 'after_setup_theme', 'att_setup' );

endif;




/**
* Featured image caption
* @since 1.0
*/
if ( !function_exists( 'att_post_feat_img_caption' ) ) :
	function att_post_feat_img_caption() {
	  global $post;
	  $thumbnail_image = get_posts( array( 'p' => get_post_thumbnail_id( get_the_ID() ), 'post_type' => 'attachment') );
	   if ( $thumbnail_image[0]->post_content !== '' ) {
    		echo '<p class="single-portfolio-image-description clearfix">'.$thumbnail_image[0]->post_content.'</p>';
  		}
	}
endif;





/**
* Change default excerpt read more style
* @since 1.0
*/
if ( !function_exists( 'att_new_excerpt_more' ) ) :
	function att_new_excerpt_more($more) {
		global $post;
		return '...';
	}
	add_filter('excerpt_more', 'att_new_excerpt_more');
endif;