<?php
/**
 * Create meta options for posts
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://authenticplorer.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://authenticplorer.com
 * @author Authentic Themes : http://www.authenticthemes.com
 */
 
$prefix = 'att_';

$att_meta_box_post_settings = array(
	'id' => 'att_custom_post_options',
	'title' =>  __('post Settings', 'authentic'),
	'post' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array(
            'name' => __('Custom post Title', 'authentic'),
            'id' => $prefix . 'custom_pp_title',
			'desc' => __('This allows you to overwrite the default post title [Plain Text]', 'authentic'),
			'default' => '',
            'type' => 'text',
			'std' => ''
        ),
	),
);

/*-----------------------------------------------------------------------------------*/
// Display meta box in edit post post
/*-----------------------------------------------------------------------------------*/

add_action('admin_menu', 'att_add_box_post_settings');

function att_add_box_post_settings() {
	global $att_meta_box_post_settings;
	
	add_meta_box(
	$att_meta_box_post_settings['id'],
	$att_meta_box_post_settings['title'], 'att_show_box_post_settings', 
	$att_meta_box_post_settings['post'], 
	$att_meta_box_post_settings['context'], 
	$att_meta_box_post_settings['priority']);

}

/*-----------------------------------------------------------------------------------*/
//	Callback function to show fields in meta box
/*-----------------------------------------------------------------------------------*/

function att_show_box_post_settings() {
	global $att_meta_box_post_settings, $post;
	
	// Use nonce for verification
	echo '<input type="hidden" name="att_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
 
	echo '<table class="form-table">';
 
	foreach ($att_meta_box_post_settings['fields'] as $field) {
		
		// get current post meta data & set default value if empty
		$meta = get_post_meta($post->ID, $field['id'], true);
		
		if (empty ($meta)) {
			$meta = $field['std']; 
		}
		
		switch ($field['type']) {
 
			
			//If Select	
			case 'select':
			
				echo '<tr>',
				'<th style="width:50%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#777; margin:5px 0 0 0;">'. $field['desc'].'</span></label></th>',
				'<td>';
			
				echo'<select name="'.$field['id'].'">';
			
				foreach ($field['options'] as $option) {
					
					echo'<option';
					if ($meta == $option ) { 
						echo ' selected="selected"'; 
					}
					echo'>'. $option .'</option>';
				
				} 
				
				echo'</select>';
			
			break;
			
			//If Text		
			case 'text':
			
			echo '<th style="width:25%"><label for="', $field['id'], '"><strong>', $field['name'], '</strong><span style=" display:block; color:#777; margin:5px 0 0 0;">'. $field['desc'].'</span></label></th>',
				'<td>';
			echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : stripslashes(htmlspecialchars(( $field['std']), ENT_QUOTES)), '" size="30" style="width:75%; margin-right: 20px; float:left;" />';
			
			break;
			

		}

	}
 
	echo '</table>';
}
 
add_action('save_post', 'att_save_data_post');

/*-----------------------------------------------------------------------------------*/
//	Save data when post is edited
/*-----------------------------------------------------------------------------------*/
 
function att_save_data_post($post_id) {
	global $att_meta_box_post_settings;
	
	if(!isset($_POST['att_meta_box_nonce'])) $_POST['att_meta_box_nonce'] = "undefine";
 
	// verify nonce
	if (!wp_verify_nonce($_POST['att_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}
 
	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}
 
	// check permissions
	if ('post' == $_POST['post_type']) {
		if (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
 
	//Save fields
	foreach ($att_meta_box_post_settings['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
 
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], stripslashes(htmlspecialchars($new)));
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}

}
?>