<?php
/**
 * Function used to control pagination on taxonomy pages
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 * @author Authentic Themes : http://www.authenticthemes.com
 */

//get posts per page
$att_option_posts_per_page = get_option( 'posts_per_page' );

//add posts per page filter
add_action( 'init', 'att_modify_posts_per_page', 0);
function att_modify_posts_per_page() {
    add_filter( 'option_posts_per_page', 'att_option_posts_per_page' );
}

//modify posts per page
function att_option_posts_per_page( $value ) {
	
	global $att_option_posts_per_page;
	
	//tax pagination
    if( is_tax('portfolio_category') || is_archive('portfolio') ||  is_tax('portfolio_tags') ) {
		return of_get_option('portfolio_pagination','-1');
	}

	else { return $att_option_posts_per_page; }
}

?>