<?php
/**
 * This file loads the CSS and Javascript used for the theme.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */
 
 
add_action('wp_enqueue_scripts','att_load_scripts');
function att_load_scripts() {
	
	
	/*******
	*** CSS
	*******************/
	
	// Main CSS
	wp_enqueue_style('style', get_stylesheet_uri() );
	
	//Responsive
	wp_enqueue_style('att-responsive', ATT_CSS_DIR .'/responsive.css');
	
	// PrettyPhoto Lightbox
	wp_enqueue_style('prettyphoto', ATT_CSS_DIR . '/prettyphoto.css');
	
	// Remove default contact 7 styling
	if( function_exists('wpcf7_enqueue_styles') ) {
		wp_dequeue_style('contact-form-7');
	}

	/*******
	*** jQuery
	*******************/
	
	// Main Scripts
	wp_enqueue_script('hoverIntent', ATT_JS_DIR .'/hoverintent.js', array('jquery'), 'r6', true);
	wp_enqueue_script('superfish', ATT_JS_DIR .'/superfish.js', array('jquery'), '1.4.8', true);
	wp_enqueue_script('isotope', ATT_JS_DIR .'/isotope.js', array('jquery'), '1.5.19', true);
	wp_enqueue_script('easing', ATT_JS_DIR .'/easing.js', array('jquery'), '1.3', true);
	wp_enqueue_script('flexslider', ATT_JS_DIR .'/flexslider.js', array('jquery'), '2', true);
	wp_enqueue_script('prettyphoto', ATT_JS_DIR .'/prettyphoto.js', array('jquery'), '3.1.4', true);
	
	// Portfolio
	if( is_singular('portfolio') ) {
		wp_enqueue_script('att-slider-portfolio', ATT_JS_DIR .'/slider_portfolio.js', false, '1.0', true);
	}
	
	// Homepage script
	if( is_front_page() ) {
			
		wp_enqueue_script('att-slider-home', ATT_JS_DIR .'/slider_home.js', false, '1.0', true);
		
		
		//localize homepage slider
		$flex_params = array(
			'slideshow' => of_get_option('slides_slideshow', '0'),
			'randomize' => of_get_option('slides_randomize', '0'),			
			'animation' => of_get_option('slides_animation', 'slide'),
			'direction' => of_get_option('slides_direction', 'horizontal'),
			'slideshowSpeed' => of_get_option('slideshow_speed', '7000'),
			'animationSpeed' => of_get_option('animation_speed', '600')
		);
		wp_localize_script( 'att-slider-home', 'flexLocalize', $flex_params );
			
	}
	
	wp_enqueue_script('att-isotope-init', ATT_JS_DIR .'/isotope_init.js', array('jquery'), '1.0', true);
	
	// Responsive
	wp_enqueue_script('fitvids', ATT_JS_DIR .'/fitvids.js', array('jquery'), 1.0, true);
	wp_enqueue_script('uniform', ATT_JS_DIR .'/uniform.js', array('jquery'), '1.7.5', true);
	wp_enqueue_script('att-responsive', ATT_JS_DIR .'/responsive.js', array('jquery'), '', true);

	// Comment replies
	if(is_single() || is_page()) {
		wp_enqueue_script('comment-reply');
	}
	
	// Localize responsive nav
	$nav_params = array(
		'text' => __('Navigation','att'),
	);
	wp_localize_script( 'att-responsive', 'navLocalize', $nav_params );
	
	// Initialize
	wp_enqueue_script('att-global-init', ATT_JS_DIR .'/initialize.js', false, '1.0', true);

	
} //end att_load_scripts()
?>