<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {
    $optionsframework_settings = get_option('optionsframework');
    $optionsframework_settings['id'] = 'options_att_themes';
    update_option('optionsframework', $optionsframework_settings);
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'att'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	$options = array();
	
	//GENERAL
	
	$options[] = array(
		'name' => __('General', 'att'),
		'type' => 'heading');
		
	$options['custom_logo'] = array(
		'name' => __('Custom Logo', 'att'),
		'desc' => __('Upload your custom logo.', 'att'),
		'std' => '',
		'id' => 'custom_logo',
		'type' => 'upload');
		
	
	//Slider
	$options[] = array(
				'name' => __('Slides', 'wpex'),
				'type' => 'heading');
			
		if ( class_exists( 'Authentic_Slides_Post_Type' ) ) {
				
			$options['slides_slideshow'] = array(
				"name" => __('Toggle: Slideshow', 'att'),
				"desc" => __('Check this box to enable automatic slideshow for your slides.', 'att'),
				"id" => "slides_slideshow",
				"std" => "true",
				"type" => "select",
				"options" => array(
					'true' => 'true',
					'false' => 'false'
				) );
				
			$options['slides_randomize'] = array(
				"name" => __('Toggle: Randomize', 'att'),
				"desc" => __('Check this box to enable the randomize feature for your slides.', 'att'),
				"id" => "slides_randomize",
				"std" => "false",
				"type" => "select",
				"options" => array(
					'true' => 'true',
					'false' => 'false'
				) );
				
			$options['slides_animation'] = array(
				"name" => __('Animation', 'att'),
				"desc" => __('Select your animation of choice.', 'att'),
				"id" => "slides_animation",
				"std" => "slide",
				"type" => "select",
				"options" => array(
					'fade' => 'fade',
					'slide' => 'slide'
				) );
				
			$options['slides_direction'] = array(
				"name" => __('Direction', 'att'),
				"desc" => __('Select the direction for your slides. Slide animation only & if using the <strong>vertical direction</strong> all slides must have the same height.', 'att'),
				"id" => "slides_direction",
				"std" => "horizontal",
				"type" => "select",
				"options" => array(
					'horizontal' => 'horizontal',
					'vertical' => 'vertical'
				));
				
			$options['slideshow_speed'] = array(
				"name" => __('SlideShow Speed', 'att'),
				"desc" => __('Enter your preferred slideshow speed in milliseconds.', 'att'),
				"id" => "slideshow_speed",
				"std" => "7000",
				"type" => "text" );
				
			$options['animation_speed'] = array(
				"name" => __('Animation Speed', 'att'),
				"desc" => __('Enter your preferred animation speed in milliseconds.', 'att'),
				"id" => "animation_speed",
				"std" => "600",
				"type" => "text" );
		}
			
		$options['slides_alt'] = array(
				"name" => __('Slider Alternative', 'att'),
				"desc" => __('If you prefer to use another slider you can enter the <strong>shortcode</strong> here.', 'att'),
				"id" => "slides_alt",
				"std" => "",
				"type" => "textarea" );
		
	//PORTFOLIO
	if ( class_exists( 'Authentic_Portfolio_Post_Type' ) ) {

		$options[] = array(
				'name' => __('Portfolio', 'wpex'),
				'type' => 'heading');
				
		$options['home_portfolio_count'] = array(
		'name' => __('Homepage: Portfolio Items Count', 'att'),
		'desc' => __('How many portfolio items do you wish to show on the homepage?', 'att'),
		'id' => 'home_portfolio_count',
		'std' => '12',
		'type' => 'text');
		
		$options['portfolio_pagination'] = array(
			'name' => __('Portfolio: Items Per Page', 'att'),
			'desc' => __('How many portfolio items do you wish to show on your portfolio templates and archives? Use -1 to show all.', 'att'),
			'id' => 'portfolio_pagination',
			'std' => '-1',
			'type' => 'text');
		
		$options['toggle_portfolio_comments'] = array(
			"name" => __('Toggle: Portfolio Comments', 'att'),
			"desc" => __('Check this box to enable comments on single portfolio posts.', 'att'),
			"id" => "toggle_portfolio_comments",
			"std" => "0",
			"type" => "checkbox");
							
		$options['toggle_portfolio_more'] = array(
			"name" => __('Toggle: Portfolio More Items Section', 'att'),
			"desc" => __('Check this box to enable the section that displays other portfolio items on single portfolio posts.', 'att'),
			"id" => "toggle_portfolio_more",
			"std" => "1",
			"type" => "checkbox");
	
	}	
	
	// BLOG
	$options[] = array(
				'name' => __('Blog', 'wpex'),
				'type' => 'heading');
						
	$options[] = array(
		"name" => __('Toggle: Featured Images On Single Blog Posts', 'att'),
		"desc" => __('Check this box to enable featured images on single blog posts.', 'att'),
		"id" => "blog_single_thumbnail",
		"std" => "1",
		"type" => "checkbox");
	
	return $options;
}


/*
 * This is an example of how to add custom scripts to the options panel.
 * This example shows/hides an option when a checkbox is clicked.
 */

add_action('optionsframework_custom_scripts', 'optionsframework_custom_scripts');

function optionsframework_custom_scripts() { ?>

<script type="text/javascript">
jQuery(document).ready(function($) {

	$('#example_showhidden').click(function() {
  		$('#section-example_text_hidden').fadeToggle(400);
	});

	if ($('#example_showhidden:checked').val() !== undefined) {
		$('#section-example_text_hidden').show();
	}

});
</script>

<?php } ?>