<?php
/**
 * This file is used for your Portfolio category pages
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */

get_header(); // Loads the header.php template
if (have_posts()) :
?>

<div id="page-heading">
	<?php if( get_post_meta($post->ID, 'att_custom_pp_title', TRUE) == '') { ?>
		<h1><?php $term = $wp_query->queried_object; echo $term->name; ?></h1>
	<?php } else { ?>
		<h1><?php echo get_post_meta($post->ID, 'att_custom_pp_title', TRUE); ?></h1>
	<?php } ?>
</div><!-- /page-heading -->

<?php if( category_description() ) { ?>
<div id="portfolio-description">
	 <?php echo category_description( ); ?>
</div><!-- /portfolio-description -->
<?php } ?>
    
<div id="portfolio-template">
	
	<div id="portfolio-wrap">
		<div id="portfolio-filter-content" class="clearfix">
			<?php
            // If there are posts load the loop-portfolio.php file
            // which contains the layout for single portfolio posts for each post in the loop
            while (have_posts()) : the_post();
                get_template_part('content','portfolio');
            endwhile; ?>
		</div><!-- /portfolio-filter-content -->
        <?php
        att_pagination(); // Paginate your portfolio items ?>
    </div><!-- /portfolio-wrap -->
</div><!-- /portfolio-template -->

<?php
endif;
get_footer(); // Loads the footer.php file ?>