<?php
/**
 * Template Name: Homepage
 *
 *
 * It is unlikely this template file will ever be used, but it's here to back you up just incase.
 *
 *
 * This template file contains the the default homepage structure for this theme
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */
 
get_header(); // Loads the header.php template ?>

<div id="home-wrap" class="clearfix ajax-wrap">

	<?php
	//get post type ==> portfolio
	global $post;
	$args = array(
		'post_type' =>'portfolio',
		'numberposts' => of_get_option('home_portfolio_count','8'),
		'suppress_filters' => false //WPML support
	);
	$portfolio_posts = get_posts($args);
	
	//show portfolio section if posts exist
	if($portfolio_posts) { ?>
		
	<div id="home-portfolio">
		<div id="portfolio-wrap">
            <div id="portfolio-filter-content" class="portfolio-isotope clearfix">
            	
                <?php
                // If there are posts load the loop-portfolio.php file
				// which contains the layout for single portfolio posts for each post in the loop
                foreach($portfolio_posts as $post) : setup_postdata($post);
                    get_template_part('content','portfolio');
                endforeach; ?>
            </div><!-- /portfolio-isotope -->
		</div><!-- /portfolio-wrap -->
	</div><!-- /home-portfolio -->
	
	<?php } ?>
	
	<?php wp_reset_postdata(); // Reset the postdata in order to prevent any loop conflicts later on ?>
    
</div><!-- /home-wrap -->   

<?php
get_footer(); // Loads the footer.php file ?>