<?php
/**
 * Template Name: Portfolio With Filter
 *
 *
 * It is unlikely this template file will ever be used, but it's here to back you up just incase.
 *
 *
 * The portfolio template showcases your portfolio items with a filterable option.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */

get_header(); // Loads the header.php template

//start page loop
if (have_posts()) : while (have_posts()) : the_post();
$att_custom_pp_title = get_post_meta($post->ID, 'att_custom_pp_title', TRUE);

?>

<div id="page-heading">
	<?php if( get_post_meta($post->ID, 'att_custom_pp_title', TRUE) == '') { ?>
		<h1><?php if ( of_get_option('portfolio_title') ) echo of_get_option('portfolio_title'); else _e('Portfolio','att'); ?></h1>
	<?php } else { ?>
		<h1><?php echo get_post_meta($post->ID, 'att_custom_pp_title', TRUE); ?></h1>
	<?php } ?>
</div><!-- /page-heading -->

<?php
//show page content if not empty
if( !empty( $post->post_content ) ) { ?>
	<div id="portfolio-description" class="clearfix">
		<?php the_content(); ?>
	</div><!-- /portfolio-description -->
<?php } ?>

<div id="portfolio-template">

	<?php 
	//get portfolio categories
	$att_port_cats = get_terms('portfolio_category', array( 'hide_empty' => '1' ) );
	
	//show filter if categories exist
	if($att_port_cats) { ?>
	<!-- Portfolio Filter -->
	<ul id="portfolio-cats" class="filter clearfix">
		<li><a href="#" class="active" data-filter="*"><span><?php _e('Show All', 'att'); ?></span></a></li>
		<?php
		foreach ($att_port_cats as $att_port_cat ) : ?>
		<li><a href="#" data-filter=".<?php echo $att_port_cat->slug; ?>"><span><?php echo $att_port_cat->name; ?></span></a></li>
		<?php endforeach; ?>
	</ul><!-- /portfolio-cats -->
	<?php } ?>
    
    <div id="portfolio-wrap">
    	<div id="portfolio-filter-content" class="portfolio-content clearfix">
			<?php
            //get post type ==> portfolio
            query_posts(
				array(
					'post_type'=>'portfolio',
					'posts_per_page' => of_get_option('portfolio_pagination'),
					'paged'=>$paged
            	)
			);
			// If there are posts load the loop-portfolio.php file
			// which contains the layout for single portfolio posts for each post in the loop
            while (have_posts()) : the_post();
				 get_template_part('content','portfolio');
			endwhile; ?>
		</div><!-- /portfolio-filter-content -->
    </div><!-- /portfolio-wrap -->
	<?php att_pagination(); // Paginate your pages ?>
	<?php wp_reset_query(); // Rest the query to avoid any conflicts ?>
</div><!-- /portfolio-template -->
<?php
endwhile;
endif;
get_footer(); // Loads the footer.php file ?>