<?php
/**
 * Template Name: Portfolio
 *
 *
 * It is unlikely this template file will ever be used, but it's here to back you up just incase.
 *
 *
 * The portfolio template showcases your portfolio items with a filterable option.
 * @package Adventure WordPress Theme
 * @since 1.0
 * @author Authentic Themes : http://www.authenticthemes.com
 * @copyright Copyright (c) 2012, Authentic Themes
 * @link http://www.authenticthemes.com
 */

get_header(); // Loads the header.php template
if (have_posts()) : while (have_posts()) : the_post(); // Start main loop

// Show featured images
if( has_post_thumbnail() ) { ?>
	<div id="page-featured-img"><img src="<?php echo wp_get_attachment_image_src( get_post_thumbnail_id() ); ?>" alt="<?php the_title(); ?>" /></div>
<?php } ?>

<div id="page-heading">
	<h1><?php if ( of_get_option('portfolio_title') ) echo of_get_option('portfolio_title'); else _e('Portfolio','att'); ?></h1>
</div><!-- /page-heading -->

<?php
//show page content if not empty
if( !empty( $post->post_content ) ) { ?>
	<div id="portfolio-description" class="clearfix">
		<?php the_content(); ?>
	</div><!-- /portfolio-description -->
<?php } ?>

<div id="portfolio-template">
    <div id="portfolio-wrap">
    	<div id="portfolio-filter-content" class="portfolio-content clearfix">
			<?php
            //get post type ==> portfolio
            query_posts(
				array(
					'post_type'=>'portfolio',
					'posts_per_page' => of_get_option('portfolio_pagination'),
					'paged'=>$paged
            	)
			);
			// If there are posts load the loop-portfolio.php file
			// which contains the layout for single portfolio posts for each post in the loop
            while (have_posts()) : the_post();
				 get_template_part('content','portfolio');
			endwhile; ?>
		</div><!-- /portfolio-filter-content -->
        <?php att_pagination(); // Paginate your pages ?>
		<?php wp_reset_query(); // Rest the query to avoid any conflicts ?>
    </div><!-- /portfolio-wrap -->
</div><!-- /portfolio-template -->

<?php
endwhile; endif; // End main loop
get_footer(); // Loads the footer.php file